<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Update Students Data</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f9fa;
        }
        .header {
            background: linear-gradient(to right, #007bff, #6610f2);
            color: white;
            padding: 20px 0;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }
        .footer {
            background-color: #343a40;
            color: white;
            padding: 10px 0;
            text-align: center;
            margin-top: 20px;
            border-radius: 0 0 10px 10px;
        }
        .badge-custom {
            background-color: #007bff;
            color: white;
            font-size: 14px;
            padding: 5px 10px;
            border-radius: 20px;
        }
        .btn-custom {
            padding: 15px 30px;
            font-size: 18px;
            border-radius: 25px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header mb-4">
        <h1>Update Students Data</h1>
        <span class="badge badge-custom">Admin Panel</span>
    </div>

    <div class="container mt-4">
        <h4 class="text-center mb-4">Manage Students' Year and Class Promotions</h4>

        <!-- Form for Updating Year and Promoting Classes -->
        <form method="POST" action="">
            <div class="row mb-3">
                <div class="col-md-3">
                    <button type="submit" name="update_year" class="btn btn-primary btn-custom w-100">
                        Update Year to Current Year
                    </button>
                </div>
                <div class="col-md-3">
                    <button type="submit" name="promote_class" class="btn btn-success btn-custom w-100">
                        Promote Students to Next Class
                    </button>
                </div>




                <div class="col-md-3">
                    <button type="submit" name="graduate_class" class="btn btn-warning btn-custom w-100">
                        Graduate Form Four to Alumni
                    </button>
                </div>
                <div class="col-md-3">
                    <button type="submit" name="update_parent" class="btn btn-info btn-custom w-100">
                        Update Parent Username
                    </button>
                </div>
            </div>
        


       
    <div class="row mb-3">
        <div class="col-md-3">
            <button type="submit" name="undo_update_year" class="btn btn-danger btn-custom w-100">
                Undo Year Update
            </button>
        </div>
        <div class="col-md-3">
            <button type="submit" name="undo_promote_class" class="btn btn-danger btn-custom w-100">
                Undo Class Promotion
            </button>
        </div>
        <div class="col-md-3">
            <button type="submit" name="undo_graduate_class" class="btn btn-danger btn-custom w-100">
                Undo Graduate Alumni
            </button>
        </div>
        <div class="col-md-3">
            <button type="submit" name="undo_update_parent" class="btn btn-danger btn-custom w-100">
                Undo Parent Username Update
            </button>
        </div>
    </div>

</form>

<?php
include 'connection.php'; // Include your database connection file

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Update Year to Current Year
    if (isset($_POST['update_year'])) {
        $updateYearQuery = "UPDATE students SET year = year + 1 WHERE class IN ('Form One', 'Form Two', 'Form Three')";
        $result = mysqli_query($con, $updateYearQuery);
        echo $result ? '<div class="alert alert-success mt-3">Year updated successfully!</div>' : '<div class="alert alert-danger mt-3">Error updating year: ' . mysqli_error($con) . '</div>';
    }

    // Promote Students to Next Class
    if (isset($_POST['promote_class'])) {
        $promoteClassQuery = "
            UPDATE students 
            SET class = CASE
                WHEN class = 'Form One' THEN 'Form Two'
                WHEN class = 'Form Two' THEN 'Form Three'
                WHEN class = 'Form Three' THEN 'Form Four'
                ELSE class
            END";
        $result = mysqli_query($con, $promoteClassQuery);
        echo $result ? '<div class="alert alert-success mt-3">Students promoted successfully!</div>' : '<div class="alert alert-danger mt-3">Error promoting students: ' . mysqli_error($con) . '</div>';
    }

    // Graduate Form Four to Alumni
    if (isset($_POST['graduate_class'])) {
        $graduateClassQuery = "UPDATE students SET class = 'Form Four-Alumni',finish_status='Completed' WHERE class = 'Form Four'";
        $result = mysqli_query($con, $graduateClassQuery);
        echo $result ? '<div class="alert alert-success mt-3">Form Four students graduated to Alumni!</div>' : '<div class="alert alert-danger mt-3">Error graduating students: ' . mysqli_error($con) . '</div>';
    }

    // Update Parent Username
    if (isset($_POST['update_parent'])) {
        $updateParentQuery = "UPDATE students SET parent_username = CONCAT(parent_username, '-MSS')";
        $result = mysqli_query($con, $updateParentQuery);
        echo $result ? '<div class="alert alert-success mt-3">Parent usernames updated successfully!</div>' : '<div class="alert alert-danger mt-3">Error updating parent usernames: ' . mysqli_error($con) . '</div>';
    }

    // UNDO ACTIONS

    // Undo Year Update
    if (isset($_POST['undo_update_year'])) {
        $undoYearQuery = "UPDATE students SET year = year - 1 WHERE class IN ('Form One', 'Form Two', 'Form Three')";
        $result = mysqli_query($con, $undoYearQuery);
        echo $result ? '<div class="alert alert-warning mt-3">Year update undone successfully!</div>' : '<div class="alert alert-danger mt-3">Error undoing year update: ' . mysqli_error($con) . '</div>';
    }

    // Undo Class Promotion
    if (isset($_POST['undo_promote_class'])) {
        $undoPromoteQuery = "
            UPDATE students 
            SET class = CASE
                WHEN class = 'Form Two' THEN 'Form One'
                WHEN class = 'Form Three' THEN 'Form Two'
                WHEN class = 'Form Four' THEN 'Form Three'
                ELSE class
            END";
        $result = mysqli_query($con, $undoPromoteQuery);
        echo $result ? '<div class="alert alert-warning mt-3">Class promotion undone successfully!</div>' : '<div class="alert alert-danger mt-3">Error undoing class promotion: ' . mysqli_error($con) . '</div>';
    }

    // Undo Graduate Alumni
    if (isset($_POST['undo_graduate_class'])) {
        $undoGraduateQuery = "UPDATE students SET class = 'Form Four' WHERE class = 'Form Four-Alumni'";
        $result = mysqli_query($con, $undoGraduateQuery);
        echo $result ? '<div class="alert alert-warning mt-3">Graduation undone successfully!</div>' : '<div class="alert alert-danger mt-3">Error undoing graduation: ' . mysqli_error($con) . '</div>';
    }

    // Undo Parent Username Update
    if (isset($_POST['undo_update_parent'])) {
        $undoParentQuery = "UPDATE students SET parent_username = REPLACE(parent_username, '-MSS', '')";
        $result = mysqli_query($con, $undoParentQuery);
        echo $result ? '<div class="alert alert-warning mt-3">Parent usernames undone successfully!</div>' : '<div class="alert alert-danger mt-3">Error undoing parent usernames: ' . mysqli_error($con) . '</div>';
    }
}

mysqli_close($con); // Close connection
?>
